<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */

  /*===================================================
    ShowFormBecomeEditor()
  ===================================================*/

  function ShowFormBecomeEditor() {

    // vars global configuration
    global $dbConn, $category_separator, $theme_path;

    // vars url & form
    global $cat;

    // vars messages
    global $msg;

    // vars template
    global $category, $username, $error_msg;

    // check if category id is valid
    $category_obj = new clsCategory;
    $category_obj->table_name = "idx_category";
    $arr_cat                  = $category_obj->GetChildren(0);
    $dummy                    = array_shift($arr_cat); // remove 0

    if (!in_array($cat, $arr_cat)) {
      if (empty($cat))
        $error_msg = $msg["10226"];
      else
        $error_msg = $msg["10228"];

      DisplayTemplate($theme_path . "become_editor_error.html", "\$error_msg");
      RunPostFilter(__FILE__);
    }

    if (empty($cat)) {
      $error_msg = $msg["10226"];
      DisplayTemplate($theme_path . "become_editor_error.html", "\$error_msg");
    }
    elseif ($_COOKIE['COOKIE_USERNAME'] == 'admin') {
      $error_msg = $msg["10227"];
      DisplayTemplate($theme_path . "become_editor_error.html", "\$error_msg");
    }
    else {

      // get username
      $username                      = $_COOKIE['COOKIE_USERNAME'];
      // get category path
      $category_obj->link_table_name = "idx_link";
      $category_obj->separator       = $category_separator;
      $category                      = $category_obj->GetCategoryPath($cat);
      $category                     .= "\n<input type=hidden name=cat value=$cat>";

      DisplayTemplate($theme_path . "become_editor_form.html", "\$username,\$category");
    }
  }


  /*===================================================
    ProcessFormBecomeEditor()
  ===================================================*/

  function ProcessFormBecomeEditor() {

    // vars global configuration
    global $site_url, $theme_path, $email_address;

    // vars url & form
    global $cat, $username;

    // vars messages
    global $msg;

    // vars template
    global $category, $name, $email;

    $category_obj = new clsCategory;
    $category_obj->table_name = "idx_category";
    $category_obj->separator  = $category_separator;
    $category                 = $category_obj->GetCategoryPath($cat);

    $links_obj = new clsLink;
    $links_obj->table_name = "idx_link";
    $links_obj->category_table_name = "idx_category";
    $links_obj->user_table_name = "idx_users";
    $links_obj->editor_table_name = "idx_editor";
    $links_obj->BecomeEditor("process_form", $username, $cat);

    // send email to administrator
    $admin_email           = $email_address;
    $body                  = EvalTemplate($theme_path . "mail/become_editor_pending_admin.mail",
                                          $links_obj->email_template_fields . ",\$site_url");
    $from                  = $email_address;
    @mail($admin_email, $msg["10221"], $body, "From: $from \nX-Mailer: INDEXU_X-Mailer/1.0");

    
    // send email to user
    $body                  = EvalTemplate($theme_path . "mail/become_editor_pending.mail",
                                          $links_obj->email_template_fields);
    $from                  = $email_address;
    @mail($email, $msg["10221"], $body, "From: $from \nX-Mailer: INDEXU_X-Mailer/1.0");

    DisplayTemplate($theme_path . "become_editor_pending.html", "\$$username,\$category");
  }


  /*===================================================
    main
  ===================================================*/

  include "application.php";

  RunPreFilter(__FILE__);
  ExecuteFilter('validate_user');
  
  if (empty($pflag)) {
    ShowFormBecomeEditor();
  }
  elseif ($pflag == 'editor') {
    ProcessFormBecomeEditor();
  }

  RunPostFilter(__FILE__);

?>